/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap.backend;

import com.floragunn.dlic.auth.ldap.LdapUser;
import com.floragunn.dlic.auth.ldap.backend.LDAPAuthenticationBackend;
import com.floragunn.dlic.auth.ldap.util.LdapHelper;
import com.floragunn.dlic.auth.ldap.util.Utils;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyAuthorizationBackend;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.support.PemKeyReader;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.HashMultimap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;
import org.ldaptive.control.RequestControl;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.AllowAnyTrustManager;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.CredentialConfigFactory;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.ThreadLocalTLSSocketFactory;

public class LDAPAuthorizationBackend
implements LegacyAuthorizationBackend {
    private static final AtomicInteger CONNECTION_COUNTER = new AtomicInteger();
    private static final String COM_SUN_JNDI_LDAP_OBJECT_DISABLE_ENDPOINT_IDENTIFICATION = "com.sun.jndi.ldap.object.disableEndpointIdentification";
    private static final List<String> DEFAULT_TLS_PROTOCOLS = Arrays.asList("TLSv1.2", "TLSv1.1");
    static final int ONE_PLACEHOLDER = 1;
    static final int TWO_PLACEHOLDER = 2;
    static final String DEFAULT_ROLEBASE = "";
    static final String DEFAULT_ROLESEARCH = "(member={0})";
    static final String DEFAULT_ROLENAME = "name";
    static final String DEFAULT_USERROLENAME = "memberOf";
    protected static final Logger log = LogManager.getLogger(LDAPAuthorizationBackend.class);
    private final Settings settings;
    private final Path configPath;
    private final List<Map.Entry<String, Settings>> roleBaseSettings;
    private final List<Map.Entry<String, Settings>> userBaseSettings;
    private static final Class clazz = ThreadLocalTLSSocketFactory.class;
    public static TypedComponent.Info<LegacyAuthorizationBackend> INFO = new TypedComponent.Info<LegacyAuthorizationBackend>(){

        public Class<LegacyAuthorizationBackend> getType() {
            return LegacyAuthorizationBackend.class;
        }

        public String getName() {
            return "ldap";
        }

        public TypedComponent.Factory<LegacyAuthorizationBackend> getFactory() {
            return LegacyComponentFactory.adapt(LDAPAuthorizationBackend::new);
        }
    };

    public LDAPAuthorizationBackend(Settings settings, Path configPath) {
        this.settings = settings;
        this.configPath = configPath;
        this.roleBaseSettings = LDAPAuthorizationBackend.getRoleSearchSettings(settings);
        this.userBaseSettings = LDAPAuthenticationBackend.getUserBaseSettings(settings);
    }

    public static void checkConnection(final ConnectionConfig connectionConfig, final String bindDn, final byte[] password) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    boolean isJava9OrHigher = LDAPAuthorizationBackend.getJavaVersion() >= 9;
                    ClassLoader originalClassloader = null;
                    if (isJava9OrHigher) {
                        originalClassloader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(new Java9CL());
                    }
                    LDAPAuthorizationBackend.checkConnection0(connectionConfig, bindDn, password, originalClassloader, isJava9OrHigher);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Connection getConnection(final Settings settings, final Path configPath) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    boolean isJava9OrHigher = LDAPAuthorizationBackend.getJavaVersion() >= 9;
                    ClassLoader originalClassloader = null;
                    if (isJava9OrHigher) {
                        originalClassloader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(new Java9CL());
                    }
                    return LDAPAuthorizationBackend.getConnection0(settings, configPath, originalClassloader, isJava9OrHigher);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static List<Map.Entry<String, Settings>> getRoleSearchSettings(Settings settings) {
        Map groupedSettings = settings.getGroups("roles", true);
        if (!groupedSettings.isEmpty()) {
            return Utils.getOrderedBaseSettings(groupedSettings);
        }
        return LDAPAuthorizationBackend.convertOldStyleSettingsToNewStyle(settings);
    }

    private static List<Map.Entry<String, Settings>> convertOldStyleSettingsToNewStyle(Settings settings) {
        HashMap<String, Settings> result = new HashMap<String, Settings>(1);
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("rolebase", DEFAULT_ROLEBASE));
        settingsBuilder.put("search", settings.get("rolesearch", DEFAULT_ROLESEARCH));
        result.put("convertedOldStyleSettings", settingsBuilder.build());
        return Collections.singletonList(result.entrySet().iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkConnection0(ConnectionConfig connectionConfig, String bindDn, byte[] password, ClassLoader cl, boolean needRestore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, LdapException {
        Connection connection = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("bindDn {}, password {}", (Object)bindDn, (Object)(password != null && password.length > 0 ? "****" : "<not set>"));
            }
            if (bindDn != null && (password == null || password.length == 0)) {
                throw new LdapException("no bindDn or no Password");
            }
            connectionConfig = ConnectionConfig.newConnectionConfig((ConnectionConfig)connectionConfig);
            connectionConfig.setConnectionInitializer((ConnectionInitializer)new BindConnectionInitializer(bindDn, new Credential(password)));
            DefaultConnectionFactory connFactory = new DefaultConnectionFactory(connectionConfig);
            connection = connFactory.getConnection();
            connection.open();
        }
        catch (Throwable throwable) {
            Utils.unbindAndCloseSilently(connection);
            connection = null;
            if (needRestore) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(cl){
                        final /* synthetic */ ClassLoader val$cl;
                        {
                            this.val$cl = classLoader;
                        }

                        @Override
                        public Void run() throws Exception {
                            Thread.currentThread().setContextClassLoader(this.val$cl);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    log.warn("Unable to restore classloader because of " + e.getException(), (Throwable)e.getException());
                }
            }
            throw throwable;
        }
        Utils.unbindAndCloseSilently(connection);
        connection = null;
        if (needRestore) {
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (PrivilegedActionException e) {
                log.warn("Unable to restore classloader because of " + e.getException(), (Throwable)e.getException());
            }
        }
    }

    private static Connection getConnection0(Settings settings, Path configPath, final ClassLoader cl, final boolean needRestore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, LdapException {
        boolean enableSSL = settings.getAsBoolean("enable_ssl", Boolean.valueOf(false));
        List ldapHosts = settings.getAsList("hosts", Collections.singletonList("localhost"));
        Connection connection = null;
        Exception lastException = null;
        for (String ldapHost : ldapHosts) {
            if (log.isTraceEnabled()) {
                log.trace("Connect to {}", (Object)ldapHost);
            }
            try {
                String[] split = ldapHost.split(":");
                int port = split.length > 1 ? Integer.parseInt(split[1]) : (enableSSL ? 636 : 389);
                ConnectionConfig config = new ConnectionConfig();
                config.setLdapUrl("ldap" + (enableSSL ? "s" : DEFAULT_ROLEBASE) + "://" + split[0] + ":" + port);
                if (log.isTraceEnabled()) {
                    log.trace("Connect to {}", (Object)config.getLdapUrl());
                }
                Map<String, Object> props = LDAPAuthorizationBackend.configureSSL(config, settings, configPath);
                String bindDn = settings.get("bind_dn", null);
                String password = settings.get("password", null);
                if (log.isDebugEnabled()) {
                    log.debug("bindDn {}, password {}", (Object)bindDn, (Object)(password != null && password.length() > 0 ? "****" : "<not set>"));
                }
                if (bindDn != null && (password == null || password.length() == 0)) {
                    log.error("No password given for bind_dn {}. Will try to authenticate anonymously to ldap", (Object)bindDn);
                }
                boolean enableClientAuth = settings.getAsBoolean("enable_ssl_client_auth", Boolean.valueOf(false));
                if (log.isDebugEnabled()) {
                    if (enableClientAuth && bindDn == null) {
                        log.debug("Will perform External SASL bind because client cert authentication is enabled");
                    } else if (bindDn == null) {
                        log.debug("Will perform anonymous bind because no bind dn is given");
                    } else if (enableClientAuth && bindDn != null) {
                        log.debug("Will perform simple bind with bind dn because to bind dn is given and overrides client cert authentication");
                    } else if (!enableClientAuth && bindDn != null) {
                        log.debug("Will perform simple bind with bind dn");
                    }
                }
                if (bindDn != null && password != null && password.length() > 0) {
                    config.setConnectionInitializer((ConnectionInitializer)new BindConnectionInitializer(bindDn, new Credential(password)));
                } else if (enableClientAuth) {
                    props.put("java.naming.security.authentication", "EXTERNAL");
                } else {
                    props.put("java.naming.security.authentication", "none");
                }
                DefaultConnectionFactory connFactory = new DefaultConnectionFactory(config);
                connFactory.getProvider().getProviderConfig().setProperties(props);
                connection = connFactory.getConnection();
                connection.open();
                if (connection != null && connection.isOpen()) break;
                Utils.unbindAndCloseSilently(connection);
                if (needRestore) {
                    LDAPAuthorizationBackend.restoreClassLoader0(cl);
                }
                connection = null;
            }
            catch (Exception e) {
                lastException = e;
                log.warn("Unable to connect to ldapserver {} due to {}. Try next.", (Object)ldapHost, (Object)e.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Unable to connect to ldapserver due to ", (Throwable)e);
                }
                Utils.unbindAndCloseSilently(connection);
                if (needRestore) {
                    LDAPAuthorizationBackend.restoreClassLoader0(cl);
                }
                connection = null;
            }
        }
        if (connection == null || !connection.isOpen()) {
            Utils.unbindAndCloseSilently(connection);
            if (needRestore) {
                LDAPAuthorizationBackend.restoreClassLoader0(cl);
            }
            connection = null;
            if (lastException == null) {
                throw new LdapException("Unable to connect to any of those ldap servers " + ldapHosts);
            }
            throw new LdapException("Unable to connect to any of those ldap servers " + ldapHosts + " due to " + lastException, lastException);
        }
        final Connection delegate = connection;
        if (log.isDebugEnabled()) {
            log.debug("Opened a connection, total count is now {}", (Object)CONNECTION_COUNTER.incrementAndGet());
        }
        return new Connection(){

            public Response<Void> reopen(BindRequest request) throws LdapException {
                if (log.isDebugEnabled()) {
                    log.debug("Reopened a connection");
                }
                return delegate.reopen(request);
            }

            public Response<Void> reopen() throws LdapException {
                if (log.isDebugEnabled()) {
                    log.debug("Reopened a connection");
                }
                return delegate.reopen();
            }

            public Response<Void> open(BindRequest request) throws LdapException {
                try {
                    if (log.isDebugEnabled() && delegate != null && delegate.isOpen()) {
                        log.debug("Opened a connection, total count is now {}", (Object)CONNECTION_COUNTER.incrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return delegate.open(request);
            }

            public Response<Void> open() throws LdapException {
                try {
                    if (log.isDebugEnabled() && delegate != null && delegate.isOpen()) {
                        log.debug("Opened a connection, total count is now {}", (Object)CONNECTION_COUNTER.incrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return delegate.open();
            }

            public boolean isOpen() {
                return delegate.isOpen();
            }

            public ProviderConnection getProviderConnection() {
                return delegate.getProviderConnection();
            }

            public ConnectionConfig getConnectionConfig() {
                return delegate.getConnectionConfig();
            }

            public void close(RequestControl[] controls) {
                try {
                    if (log.isDebugEnabled() && delegate != null && delegate.isOpen()) {
                        log.debug("Closed a connection, total count is now {}", (Object)CONNECTION_COUNTER.decrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    delegate.close(controls);
                }
                finally {
                    this.restoreClassLoader();
                }
            }

            public void close() {
                try {
                    if (log.isDebugEnabled() && delegate != null && delegate.isOpen()) {
                        log.debug("Closed a connection, total count is now {}", (Object)CONNECTION_COUNTER.decrementAndGet());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    delegate.close();
                }
                finally {
                    this.restoreClassLoader();
                }
            }

            private void restoreClassLoader() {
                if (needRestore) {
                    LDAPAuthorizationBackend.restoreClassLoader0(cl);
                }
            }
        };
    }

    private static void restoreClassLoader0(final ClassLoader cl) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            log.warn("Unable to restore classloader because of " + e.getException(), (Throwable)e.getException());
        }
    }

    private static Map<String, Object> configureSSL(ConnectionConfig config, Settings settings, Path configPath) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        boolean enableSSL = settings.getAsBoolean("enable_ssl", Boolean.valueOf(false));
        boolean enableStartTLS = settings.getAsBoolean("enable_start_tls", Boolean.valueOf(false));
        if (enableSSL || enableStartTLS) {
            CredentialConfig cc;
            boolean verifyHostnames;
            boolean enableClientAuth = settings.getAsBoolean("enable_ssl_client_auth", Boolean.valueOf(false));
            boolean trustAll = settings.getAsBoolean("trust_all", Boolean.valueOf(false));
            boolean bl = verifyHostnames = !trustAll && settings.getAsBoolean("verify_hostnames", Boolean.valueOf(true)) != false;
            if (log.isDebugEnabled()) {
                log.debug("verifyHostname {}:", (Object)verifyHostnames);
                log.debug("trustall {}:", (Object)trustAll);
            }
            if (enableStartTLS && !verifyHostnames) {
                props.put("jndi.starttls.allowAnyHostname", "true");
            }
            boolean pem = settings.get("pemtrustedcas_filepath", null) != null || settings.get("pemtrustedcas_content", null) != null;
            SslConfig sslConfig = new SslConfig();
            if (pem) {
                PrivateKey authenticationKey;
                X509Certificate authenticationCertificate;
                X509Certificate[] trustCertificates = PemKeyReader.loadCertificatesFromStream((InputStream)PemKeyReader.resolveStream((String)"pemtrustedcas_content", (Settings)settings));
                if (trustCertificates == null) {
                    trustCertificates = PemKeyReader.loadCertificatesFromFile((String)PemKeyReader.resolve((String)"pemtrustedcas_filepath", (Settings)settings, (Path)configPath, (!trustAll ? 1 : 0) != 0));
                }
                if ((authenticationCertificate = PemKeyReader.loadCertificateFromStream((InputStream)PemKeyReader.resolveStream((String)"pemcert_content", (Settings)settings))) == null) {
                    authenticationCertificate = PemKeyReader.loadCertificateFromFile((String)PemKeyReader.resolve((String)"pemcert_filepath", (Settings)settings, (Path)configPath, (boolean)enableClientAuth));
                }
                if ((authenticationKey = PemKeyReader.loadKeyFromStream((String)settings.get("pemkey_password"), (InputStream)PemKeyReader.resolveStream((String)"pemkey_content", (Settings)settings))) == null) {
                    authenticationKey = PemKeyReader.loadKeyFromFile((String)settings.get("pemkey_password"), (String)PemKeyReader.resolve((String)"pemkey_filepath", (Settings)settings, (Path)configPath, (boolean)enableClientAuth));
                }
                cc = CredentialConfigFactory.createX509CredentialConfig((X509Certificate[])trustCertificates, (X509Certificate)authenticationCertificate, (PrivateKey)authenticationKey);
                if (log.isDebugEnabled()) {
                    log.debug("Use PEM to secure communication with LDAP server (client auth is {})", (Object)(authenticationKey != null ? 1 : 0));
                }
            } else {
                String[] stringArray;
                KeyStore trustStore = PemKeyReader.loadKeyStore((String)PemKeyReader.resolve((String)"searchguard.ssl.transport.truststore_filepath", (Settings)settings, (Path)configPath, (!trustAll ? 1 : 0) != 0), (String)settings.get("searchguard.ssl.transport.truststore_password", "changeit"), (String)settings.get("searchguard.ssl.transport.truststore_type"));
                List trustStoreAliases = settings.getAsList("ca_alias", null);
                KeyStore keyStore = PemKeyReader.loadKeyStore((String)PemKeyReader.resolve((String)"searchguard.ssl.transport.keystore_filepath", (Settings)settings, (Path)configPath, (boolean)enableClientAuth), (String)settings.get("searchguard.ssl.transport.keystore_password", "changeit"), (String)settings.get("searchguard.ssl.transport.keystore_type"));
                String keyStorePassword = settings.get("searchguard.ssl.transport.keystore_password", "changeit");
                String keyStoreAlias = settings.get("cert_alias", null);
                if (keyStoreAlias == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = keyStoreAlias;
                }
                String[] keyStoreAliases = stringArray;
                if (enableClientAuth && keyStoreAliases == null) {
                    throw new IllegalArgumentException("cert_alias not given");
                }
                if (log.isDebugEnabled()) {
                    log.debug("Use Trust-/Keystore to secure communication with LDAP server (client auth is {})", (Object)(keyStore != null ? 1 : 0));
                    log.debug("trustStoreAliases: {}, keyStoreAlias: {}", (Object)trustStoreAliases, (Object)keyStoreAlias);
                }
                cc = CredentialConfigFactory.createKeyStoreCredentialConfig((KeyStore)trustStore, (String[])(trustStoreAliases == null ? null : trustStoreAliases.toArray(new String[0])), (KeyStore)keyStore, (String)keyStorePassword, (String[])keyStoreAliases);
            }
            sslConfig.setCredentialConfig(cc);
            if (trustAll) {
                sslConfig.setTrustManagers(new TrustManager[]{new AllowAnyTrustManager()});
            }
            if (!verifyHostnames) {
                sslConfig.setHostnameVerifier((CertificateHostnameVerifier)new AllowAnyHostnameVerifier());
                String deiProp = System.getProperty(COM_SUN_JNDI_LDAP_OBJECT_DISABLE_ENDPOINT_IDENTIFICATION);
                if (deiProp == null || !Boolean.parseBoolean(deiProp)) {
                    log.warn("In order to disable host name verification for LDAP connections (verify_hostnames: true), you also need to set set the system property com.sun.jndi.ldap.object.disableEndpointIdentification to true when starting the JVM running ES. This applies for all Java versions released since July 2018.");
                }
                System.setProperty(COM_SUN_JNDI_LDAP_OBJECT_DISABLE_ENDPOINT_IDENTIFICATION, "true");
            }
            List enabledCipherSuites = settings.getAsList("enabled_ssl_ciphers", Collections.emptyList());
            List enabledProtocols = settings.getAsList("enabled_ssl_protocols", DEFAULT_TLS_PROTOCOLS);
            if (!enabledCipherSuites.isEmpty()) {
                sslConfig.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[0]));
                log.debug("enabled ssl cipher suites for ldaps {}", (Object)enabledCipherSuites);
            }
            log.debug("enabled ssl/tls protocols for ldaps {}", (Object)enabledProtocols);
            sslConfig.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            config.setSslConfig(sslConfig);
        }
        config.setUseSSL(enableSSL);
        config.setUseStartTLS(enableStartTLS);
        long connectTimeout = settings.getAsLong("connect_timeout", Long.valueOf(5000L));
        long responseTimeout = settings.getAsLong("response_timeout", Long.valueOf(0L));
        config.setConnectTimeout(Duration.ofMillis(connectTimeout < 0L ? 0L : connectTimeout));
        config.setResponseTimeout(Duration.ofMillis(responseTimeout < 0L ? 0L : responseTimeout));
        if (log.isDebugEnabled()) {
            log.debug("Connect timeout: " + config.getConnectTimeout() + "/ResponseTimeout: " + config.getResponseTimeout());
        }
        return props;
    }

    public void fillRoles(User user, AuthCredentials optionalAuthCreds) throws ElasticsearchSecurityException {
        List skipUsers;
        String originalUserName;
        String authenticatedUser;
        if (user == null) {
            return;
        }
        LdapEntry entry = null;
        String dn = null;
        if (log.isDebugEnabled()) {
            log.debug("DBGTRACE (2): username=" + user.getName() + " -> " + Arrays.toString(user.getName().getBytes(StandardCharsets.UTF_8)));
        }
        if (user instanceof LdapUser && ((LdapUser)user).getUserEntry() != null && ((LdapUser)user).getUserEntry().getLdaptiveEntry() != null) {
            entry = ((LdapUser)user).getUserEntry().getLdaptiveEntry();
            dn = entry.getDn();
            authenticatedUser = entry.getDn();
            originalUserName = ((LdapUser)user).getOriginalUsername();
        } else {
            authenticatedUser = user.getName();
            originalUserName = user.getName();
        }
        if (log.isDebugEnabled()) {
            log.debug("DBGTRACE (3): authenticatedUser=" + authenticatedUser + " -> " + Arrays.toString(authenticatedUser.getBytes(StandardCharsets.UTF_8)));
        }
        boolean rolesearchEnabled = this.settings.getAsBoolean("rolesearch_enabled", Boolean.valueOf(true));
        if (log.isDebugEnabled()) {
            log.debug("Try to get roles for {}", (Object)authenticatedUser);
        }
        if (log.isTraceEnabled()) {
            log.trace("user class: {}", user.getClass());
            log.trace("authenticatedUser: {}", (Object)authenticatedUser);
            log.trace("originalUserName: {}", (Object)originalUserName);
            log.trace("entry: {}", (Object)String.valueOf(entry));
            log.trace("dn: {}", (Object)dn);
        }
        if (!(skipUsers = this.settings.getAsList("skip_users", Collections.emptyList())).isEmpty() && (WildcardMatcher.matchAny((Collection)skipUsers, (String)originalUserName) || WildcardMatcher.matchAny((Collection)skipUsers, (String)authenticatedUser))) {
            if (log.isDebugEnabled()) {
                log.debug("Skipped search roles of user {}/{}", (Object)authenticatedUser, (Object)originalUserName);
            }
            return;
        }
        Connection connection = null;
        try {
            connection = LDAPAuthorizationBackend.getConnection(this.settings, this.configPath);
            if (entry == null || dn == null) {
                if (this.isValidDn(authenticatedUser)) {
                    if (log.isTraceEnabled()) {
                        log.trace("{} is a valid DN", (Object)authenticatedUser);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("DBGTRACE (4): authenticatedUser=" + authenticatedUser + " -> " + Arrays.toString(authenticatedUser.getBytes(StandardCharsets.UTF_8)));
                    }
                    if ((entry = LdapHelper.lookup(connection, authenticatedUser)) == null) {
                        throw new ElasticsearchSecurityException("No user '" + authenticatedUser + "' found", new Object[0]);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("DBGTRACE (5): authenticatedUser=" + user.getName() + " -> " + Arrays.toString(user.getName().getBytes(StandardCharsets.UTF_8)));
                    }
                    entry = LDAPAuthenticationBackend.exists(user.getName(), connection, this.settings, this.userBaseSettings);
                    if (log.isTraceEnabled()) {
                        log.trace("{} is not a valid DN and was resolved to {}", (Object)authenticatedUser, (Object)entry);
                    }
                    if (entry == null || entry.getDn() == null) {
                        throw new ElasticsearchSecurityException("No user " + authenticatedUser + " found", new Object[0]);
                    }
                }
                dn = entry.getDn();
                if (log.isTraceEnabled()) {
                    log.trace("User found with DN {}", (Object)dn);
                }
                if (log.isDebugEnabled()) {
                    log.debug("DBGTRACE (6): dn" + dn + " -> " + Arrays.toString(dn.getBytes(StandardCharsets.UTF_8)));
                }
            }
            HashSet<LdapName> ldapRoles = new HashSet<LdapName>(150);
            HashSet<String> nonLdapRoles = new HashSet<String>(150);
            HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
            String userRoleNames = this.settings.get("userrolename", DEFAULT_USERROLENAME);
            if (log.isTraceEnabled()) {
                log.trace("raw userRoleName(s): {}", (Object)userRoleNames);
            }
            for (String userRoleName : userRoleNames.split(",")) {
                String roleName = userRoleName.trim();
                if (entry.getAttribute(roleName) == null) continue;
                Collection userRoles = entry.getAttribute(roleName).getStringValues();
                Iterator iterator = userRoles.iterator();
                while (iterator.hasNext()) {
                    String possibleRoleDN = (String)iterator.next();
                    if (log.isDebugEnabled()) {
                        log.debug("DBGTRACE (7): possibleRoleDN" + possibleRoleDN);
                    }
                    if (this.isValidDn(possibleRoleDN)) {
                        LdapName ldapName = new LdapName(possibleRoleDN);
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                        continue;
                    }
                    nonLdapRoles.add(possibleRoleDN);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("User attr. ldap roles count: {}", (Object)ldapRoles.size());
                log.trace("User attr. ldap roles {}", ldapRoles);
                log.trace("User attr. non-ldap roles count: {}", (Object)nonLdapRoles.size());
                log.trace("User attr. non-ldap roles {}", nonLdapRoles);
            }
            String roleName = this.settings.get("rolename", DEFAULT_ROLENAME);
            if (log.isTraceEnabled()) {
                log.trace("roleName: {}", (Object)roleName);
            }
            String userRoleAttributeName = this.settings.get("userroleattribute", null);
            if (log.isTraceEnabled()) {
                log.trace("userRoleAttribute: {}", (Object)userRoleAttributeName);
                log.trace("rolesearch: {}", (Object)this.settings.get("rolesearch", DEFAULT_ROLESEARCH));
            }
            String userRoleAttributeValue = null;
            LdapAttribute userRoleAttribute = entry.getAttribute(userRoleAttributeName);
            if (userRoleAttribute != null) {
                userRoleAttributeValue = Utils.getSingleStringValue(userRoleAttribute);
            }
            if (rolesearchEnabled) {
                String escapedDn = dn;
                if (log.isDebugEnabled()) {
                    log.debug("DBGTRACE (8): escapedDn" + escapedDn);
                }
                for (Map.Entry entry2 : this.roleBaseSettings) {
                    Settings roleSearchSettings = (Settings)entry2.getValue();
                    SearchFilter f = new SearchFilter();
                    f.setFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                    f.setParameter(0, (Object)escapedDn);
                    f.setParameter(1, (Object)originalUserName);
                    f.setParameter(2, userRoleAttributeValue == null ? Integer.valueOf(2) : userRoleAttributeValue);
                    List<LdapEntry> rolesResult = LdapHelper.search(connection, roleSearchSettings.get("base", DEFAULT_ROLEBASE), f, SearchScope.SUBTREE);
                    if (log.isTraceEnabled()) {
                        log.trace("Results for LDAP group search for " + escapedDn + " in base " + (String)entry2.getKey() + ":\n" + rolesResult);
                    }
                    if (rolesResult == null || rolesResult.isEmpty()) continue;
                    for (LdapEntry searchResultEntry : rolesResult) {
                        LdapName ldapName = new LdapName(searchResultEntry.getDn());
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.put((Object)ldapName, (Object)entry2);
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("roles count total {}", (Object)ldapRoles.size());
            }
            if (this.settings.getAsBoolean("resolve_nested_roles", Boolean.valueOf(false)).booleanValue()) {
                List nestedRoleFilter = this.settings.getAsList("nested_role_filter", Collections.emptyList());
                if (log.isTraceEnabled()) {
                    log.trace("Evaluate nested roles");
                }
                HashSet<LdapName> nestedReturn = new HashSet<LdapName>(ldapRoles);
                for (LdapName roleLdapName : ldapRoles) {
                    Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)roleLdapName);
                    if (nameRoleSearchBaseKeys == null) {
                        log.error("Could not find roleSearchBaseKeys for " + roleLdapName + "; existing: " + resultRoleSearchBaseKeys);
                        continue;
                    }
                    Set<LdapName> nestedRoles = this.resolveNestedRoles(roleLdapName, connection, userRoleNames, 0, rolesearchEnabled, nameRoleSearchBaseKeys, nestedRoleFilter);
                    if (log.isTraceEnabled()) {
                        log.trace("{} nested roles for {}", (Object)nestedRoles.size(), (Object)roleLdapName);
                    }
                    nestedReturn.addAll(nestedRoles);
                }
                for (LdapName roleLdapName : nestedReturn) {
                    String role = this.getRoleFromEntry(connection, roleLdapName, roleName);
                    if (!Strings.isNullOrEmpty((String)role)) {
                        user.addRole(role);
                        continue;
                    }
                    log.warn("No or empty attribute '{}' for entry {}", (Object)roleName, (Object)roleLdapName);
                }
            } else {
                for (LdapName roleLdapName : ldapRoles) {
                    String string = this.getRoleFromEntry(connection, roleLdapName, roleName);
                    if (!Strings.isNullOrEmpty((String)string)) {
                        user.addRole(string);
                        continue;
                    }
                    log.warn("No or empty attribute '{}' for entry {}", (Object)roleName, (Object)roleLdapName);
                }
            }
            for (String nonLdapRoleName : nonLdapRoles) {
                user.addRole(nonLdapRoleName);
            }
            if (log.isDebugEnabled()) {
                log.debug("Roles for {} -> {}", (Object)user.getName(), (Object)user.getRoles());
            }
            if (log.isTraceEnabled()) {
                log.trace("returned user: {}", (Object)user);
            }
        }
        catch (Exception e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to fill user roles due to ", (Throwable)e);
                }
                throw new ElasticsearchSecurityException(e.toString(), e, new Object[0]);
            }
            catch (Throwable throwable) {
                Utils.unbindAndCloseSilently(connection);
                throw throwable;
            }
        }
        Utils.unbindAndCloseSilently(connection);
    }

    protected Set<LdapName> resolveNestedRoles(LdapName roleDn, Connection ldapConnection, String userRoleName, int depth, boolean rolesearchEnabled, Set<Map.Entry<String, Settings>> roleSearchBaseSettingsSet, List<String> roleFilter) throws ElasticsearchSecurityException, LdapException {
        if (!roleFilter.isEmpty() && WildcardMatcher.matchAny(roleFilter, (String)roleDn.toString())) {
            if (log.isTraceEnabled()) {
                log.trace("Filter nested role {}", (Object)roleDn);
            }
            return Collections.emptySet();
        }
        ++depth;
        HashSet<LdapName> result = new HashSet<LdapName>(20);
        HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
        LdapEntry e0 = LdapHelper.lookup(ldapConnection, roleDn.toString());
        if (e0.getAttribute(userRoleName) != null) {
            Collection userRoles = e0.getAttribute(userRoleName).getStringValues();
            for (String string : userRoles) {
                if (log.isDebugEnabled()) {
                    log.debug("DBGTRACE (10): possibleRoleDN" + string);
                }
                if (this.isValidDn(string)) {
                    try {
                        LdapName ldapName = new LdapName(string);
                        result.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                    }
                    catch (InvalidNameException ldapName) {}
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Cannot add {} as a role because its not a valid dn", (Object)string);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("result nested attr count for depth {} : {}", (Object)depth, (Object)result.size());
        }
        if (rolesearchEnabled) {
            String escapedDn = roleDn.toString();
            if (log.isDebugEnabled()) {
                log.debug("DBGTRACE (10): escapedDn" + escapedDn);
            }
            for (Map.Entry entry : Utils.getOrderedBaseSettings(roleSearchBaseSettingsSet)) {
                Settings roleSearchSettings = (Settings)entry.getValue();
                SearchFilter f = new SearchFilter();
                f.setFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                f.setParameter(0, (Object)escapedDn);
                f.setParameter(1, (Object)escapedDn);
                List<LdapEntry> foundEntries = LdapHelper.search(ldapConnection, roleSearchSettings.get("base", DEFAULT_ROLEBASE), f, SearchScope.SUBTREE);
                if (log.isTraceEnabled()) {
                    log.trace("Results for LDAP group search for " + escapedDn + " in base " + (String)entry.getKey() + ":\n" + foundEntries);
                }
                if (foundEntries == null) continue;
                for (LdapEntry entry2 : foundEntries) {
                    try {
                        LdapName dn = new LdapName(entry2.getDn());
                        result.add(dn);
                        resultRoleSearchBaseKeys.put((Object)dn, (Object)entry);
                    }
                    catch (InvalidNameException e) {
                        throw new LdapException((Exception)e);
                    }
                }
            }
        }
        int maxDepth = 30;
        try {
            maxDepth = this.settings.getAsInt("max_nested_depth", Integer.valueOf(30));
        }
        catch (Exception e) {
            log.error("max_nested_depth is not parseable: " + e, (Throwable)e);
        }
        if (depth < maxDepth) {
            for (LdapName ldapName : new HashSet<LdapName>(result)) {
                Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)ldapName);
                if (nameRoleSearchBaseKeys == null) {
                    log.error("Could not find roleSearchBaseKeys for " + ldapName + "; existing: " + resultRoleSearchBaseKeys);
                    continue;
                }
                Set<LdapName> in = this.resolveNestedRoles(ldapName, ldapConnection, userRoleName, depth, rolesearchEnabled, nameRoleSearchBaseKeys, roleFilter);
                result.addAll(in);
            }
        }
        return result;
    }

    public String getType() {
        return "ldap";
    }

    private boolean isValidDn(String dn) {
        if (Strings.isNullOrEmpty((String)dn)) {
            return false;
        }
        try {
            new LdapName(dn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getRoleFromEntry(Connection ldapConnection, LdapName ldapName, String role) {
        if (ldapName == null || Strings.isNullOrEmpty((String)role)) {
            return null;
        }
        if ("dn".equalsIgnoreCase(role)) {
            return ldapName.toString();
        }
        try {
            LdapAttribute roleAttribute;
            LdapEntry roleEntry = LdapHelper.lookup(ldapConnection, ldapName.toString());
            if (roleEntry != null && (roleAttribute = roleEntry.getAttribute(role)) != null) {
                return Utils.getSingleStringValue(roleAttribute);
            }
        }
        catch (LdapException e) {
            log.error("Unable to handle role {} because of ", (Object)ldapName, (Object)e.toString(), (Object)e);
        }
        return null;
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            int nextDot = version.indexOf(46, 2);
            if (nextDot == -1) {
                log.error("Invalid java version " + version);
                return -1;
            }
            return Integer.parseInt(version.substring(2, nextDot));
        }
        if (StringUtils.isNumeric((CharSequence)version)) {
            return Integer.parseInt(version);
        }
        int nextDot = version.indexOf(46);
        if (nextDot == -1) {
            log.error("Invalid java version " + version);
            return -1;
        }
        return Integer.parseInt(version.substring(0, nextDot));
    }

    private static final class Java9CL
    extends ClassLoader {
        public Java9CL() {
        }

        public Java9CL(ClassLoader parent) {
            super(parent);
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            if (!name.equalsIgnoreCase("org.ldaptive.ssl.ThreadLocalTLSSocketFactory")) {
                return super.loadClass(name);
            }
            return clazz;
        }
    }
}

